package ru.yandex.market.clickphite.dictionary.processors;

import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.DictionaryProcessor;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public class CategoriesDictionaryProcessor implements DictionaryProcessor {

    @Override
    public void insertData(Dictionary dictionary, BufferedReader reader,
                           Consumer<List<Object>> consumer) throws IOException {
        CategoryTree categoryTree = buildTree(reader);
        categoryTree.consumeNodeValues(consumer);
    }

    private CategoryTree buildTree(BufferedReader bufferedReader) throws IOException {
        CategoryTree categoryTree = new CategoryTree();
        Map<String, String> values = new HashMap<>();

        String line;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.matches("^\\d+:$")) {
                if (!values.isEmpty()) {
                    categoryTree.addNode(values);
                }
                values.clear();
                continue;
            }
            String[] part = line.split(": ");
            if (part.length < 2) {
                continue;
            }
            values.put(part[0].trim(), part[1].trim());
        }

        if (!values.isEmpty()) {
            categoryTree.addNode(values);
        }

        categoryTree.buildFullNodeNames();

        return categoryTree;
    }
}
