package ru.yandex.market.clickphite.dictionary.processors;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickhouse.ddl.ColumnTypeBase;

import java.util.Objects;

public class JsonEmptyAsNullDictionaryProcessor extends JsonDictionaryProcessor {

    protected Object parse(JsonNode node, ColumnTypeBase type) {
        Preconditions.checkArgument(!Objects.requireNonNull(node).isNull());
        if (!type.isArray() && !Sets.<ColumnTypeBase>newHashSet(ColumnType.String).contains(type)) {
            if (node.asText().isEmpty()) {
                return null;
            }
        }
        return super.parse(node, type);
    }
}
