package ru.yandex.market.clickphite.dictionary.processors;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnTypeBase;
import ru.yandex.market.clickphite.dictionary.Dictionary;
import ru.yandex.market.clickphite.dictionary.DictionaryProcessor;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * @author Denis Khurtin <dkhurtin@yandex-team.ru>
 */
public class TsvDictionaryProcessor implements DictionaryProcessor {

    @Override
    public void insertData(Dictionary dictionary, BufferedReader reader,
                           Consumer<List<Object>> consumer) throws IOException {
        List<Column> columns = dictionary.getColumns();

        String line;
        while ((line = reader.readLine()) != null) {
            String[] items = line.split("\t", -1);
            if (items.length < columns.size()) {
                continue;
            }

            List<Object> values = new ArrayList<>(columns.size());

            for (int i = 0; i < columns.size(); ++i) {
                values.add(columns.get(i).getType().parseValue(items[i], ColumnTypeBase.dateTimeFormatHolder.get()));
            }

            consumer.accept(values);
        }
    }
}
