package ru.yandex.market.clickphite.meta;

import ru.yandex.market.clickphite.metric.MetricQueue;

import java.util.Date;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 09/02/16
 */
public class MetricData {

    private final String metricId;
    private final MetricQueue metricQueue;
    private final Date updated;

    public MetricData(String metricId, MetricQueue metricQueue) {
        this(metricId, metricQueue, new Date());
    }

    public MetricData(String metricId, MetricQueue metricQueue, Date updated) {
        this.metricId = metricId;
        this.metricQueue = metricQueue;
        this.updated = updated;
    }

    public String getMetricId() {
        return metricId;
    }

    public MetricQueue getMetricQueue() {
        return metricQueue;
    }

    public Date getUpdated() {
        return updated;
    }
}
