package ru.yandex.market.clickphite.metric;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 01.12.16
 */
public class AsyncMetricGroupMonitoring {
    private static final Logger log = LogManager.getLogger();

    private MetricGroupMonitoring metricGroupMonitoring;
    private final ExecutorService executorService;

    public AsyncMetricGroupMonitoring() {
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public Future<?> reportSuccess(MetricContextGroup metricContextGroup) {
        return executorService.submit(() -> {
            try {
                metricGroupMonitoring.reportSuccess(metricContextGroup);
            } catch (Exception e) {
                log.error("Error occurred while reporting metric monitoring", e);
                throw e;
            }
        });
    }

    public Future<?> reportFailure(MetricContextGroup metricContextGroup) {
        return executorService.submit(() -> {
            try {
                metricGroupMonitoring.reportFailure(metricContextGroup);
            } catch (Exception e) {
                log.error("Error occurred while reporting metric monitoring", e);
                throw e;
            }
        });
    }

    public void actualizeMetrics(List<MetricContextGroup> allMetricContextGroups) {
        executorService.submit(() -> {
            try {
                metricGroupMonitoring.actualizeMetrics(allMetricContextGroups);
            } catch (Exception e) {
                log.error("Error occured while removing outdated metrics", e);
            }
        });
    }

    public void setTotalMetricCount(int totalMetricCount) {
        metricGroupMonitoring.setTotalMetricCount(totalMetricCount);
    }

    public void setOk() {
        metricGroupMonitoring.setOk();
    }

    @Required
    public void setMetricGroupMonitoring(MetricGroupMonitoring metricGroupMonitoring) {
        this.metricGroupMonitoring = metricGroupMonitoring;
    }
}
