package ru.yandex.market.clickphite.metric;

import ru.yandex.market.clickhouse.HttpResultRow;
import ru.yandex.market.clickphite.ProcessStatus;
import ru.yandex.market.clickphite.Queriable;

import java.io.IOException;
import java.util.List;
import java.util.Optional;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 21.09.17
 */
public interface MetricContextGroup extends Queriable {
    ProcessStatus getProcessStatus();
    List<MetricContext> getMetricContexts();
    MetricQueries getQueries();
    MetricQueries getMetricQueries();

    String getId();

    SentMetricsStat.Builder sendMetrics(List<HttpResultRow> httpResultRows,
                                MetricServiceContext metricServiceContext,
                                SentMetricsStat.Builder statBuilder) throws IOException;

    Optional<MetricContextGroup> getOrigin();
}
