package ru.yandex.market.clickphite.metric;

import ru.yandex.market.clickhouse.HttpResultRow;
import ru.yandex.market.clickphite.QueryBuilder;

import java.util.Map;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 18.09.17
 */
public class MetricResultRow {
    private final HttpResultRow httpRow;
    private final int metricIndex;
    private final Map<String, String> splitsAlternativeNames;

    MetricResultRow(HttpResultRow httpRow, int metricIndex, Map<String, String> splitsAlternativeNames) {
        this.httpRow = httpRow;
        this.metricIndex = metricIndex;
        this.splitsAlternativeNames = splitsAlternativeNames;
    }

    public String getSplitValue(String splitName) {
        if (splitsAlternativeNames.containsKey(splitName)) {
            return httpRow.getString(splitsAlternativeNames.get(splitName));
        }
        return httpRow.getString(splitName);
    }

    public int getTimestampSeconds() {
        return httpRow.getInt(QueryBuilder.TIMESTAMP_INDEX);
    }

    public double getValue() {
        return httpRow.getDouble(metricIndex + QueryBuilder.VALUE_INDEX);
    }

    public double[] getQuantileValueArray() {
        return httpRow.getDoubleArray(metricIndex + QueryBuilder.VALUE_INDEX);
    }

    public double getValue(String clickHouseName) {
        String fieldName = clickHouseName + "_" + metricIndex;
        return httpRow.getDouble(fieldName);
    }
}
