package ru.yandex.market.clickphite.metric;

import ru.yandex.market.clickhouse.HttpResultRow;
import ru.yandex.market.clickphite.DateTimeUtils;
import ru.yandex.market.clickphite.graphite.GraphiteClient;
import ru.yandex.market.clickphite.graphite.Metric;
import ru.yandex.market.clickphite.solomon.SolomonClient;
import ru.yandex.market.statface.StatfaceClient;

import java.io.IOException;
import java.util.Date;
import java.util.List;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 25/02/16
 */
public interface MetricServiceContext {
    GraphiteClient getGraphiteClient();

    StatfaceClient getStatfaceClient();

    SolomonClient getSolomonClient();

    void sendGraphiteMetrics(List<Metric> metrics) throws IOException;

    int getRowTimestampSeconds(HttpResultRow row);

    default Date getRowDate(MetricResultRow row) {
        return DateTimeUtils.dateFromTimeStampSeconds(row.getTimestampSeconds());
    }
}
