package ru.yandex.market.clickphite.metric;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 11.10.17
 */
public class SentMetricsStat {
    private static final MetricContext.SendStats DEFAULT_SEND_STATS = new MetricContext.SendStats(0, 0);
    private static final Duration DEFAULT_DURATION = Duration.ZERO;

    private final Map<MetricContext, MetricContext.SendStats> metricToStats;
    private final Map<MetricContext, Duration> metricToSendDuration;

    private SentMetricsStat(Builder builder) {
        this.metricToStats = builder.metricToStats;
        this.metricToSendDuration = builder.metricToSendDuration;
    }

    static Builder builder() {
        return new Builder();
    }

    Duration getSendDuration(MetricContext metricContext) {
        return metricToSendDuration.getOrDefault(metricContext, DEFAULT_DURATION);
    }

    MetricContext.SendStats getSendStats(MetricContext metricContext) {
        return metricToStats.getOrDefault(metricContext, DEFAULT_SEND_STATS);
    }

    public static class Builder {
        private final Map<MetricContext, MetricContext.SendStats> metricToStats = new HashMap<>();
        private final Map<MetricContext, Duration> metricToSendDuration = new HashMap<>();

        private Builder() {
        }

        Builder addMetricSendStats(MetricContext metricContext, MetricContext.SendStats sendStats) {
            this.metricToStats.merge(metricContext, sendStats, MetricContext.SendStats::plus);
            return this;
        }

        Builder addMetricSendDuration(MetricContext metricContext, Duration sendDuration) {
            this.metricToSendDuration.merge(metricContext, sendDuration, Duration::plus);
            return this;
        }

        public SentMetricsStat build() {
            return new SentMetricsStat(this);
        }
    }
}
