package ru.yandex.market.clickphite.metric.solomon;

import ru.yandex.market.clickphite.solomon.SolomonShardId;
import ru.yandex.market.clickphite.solomon.dto.SolomonSensor;

import java.util.List;
import java.util.Map;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 27.07.2018
 */
class PushSolomonSensorsRequest {
    private final SolomonShardId shardId;
    private final Map<String, String> commonLabels;
    private final List<SolomonSensor> sensors;

    PushSolomonSensorsRequest(
        SolomonShardId shardId,
        Map<String, String> commonLabels,
        List<SolomonSensor> sensors
    ) {
        this.shardId = shardId;
        this.commonLabels = commonLabels;
        this.sensors = sensors;
    }

    SolomonShardId getShardId() {
        return shardId;
    }

    Map<String, String> getCommonLabels() {
        return commonLabels;
    }

    List<SolomonSensor> getSensors() {
        return sensors;
    }
}
