package ru.yandex.market.clickphite.monitoring;

import ru.yandex.market.clickphite.config.monitoring.MonitoringConfig;
import ru.yandex.market.clickphite.metric.MetricContext;
import ru.yandex.market.clickphite.metric.MetricListener;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 05/11/15
 */
public abstract class CheckContext implements MetricListener {

    private static final int RU_REGION = 225;

    protected final MonitoringConfig monitoringConfig;
    protected final MetricContext metricContext;

    public CheckContext(MonitoringConfig monitoringConfig, MetricContext metricContext) {
        this.monitoringConfig = monitoringConfig;
        this.metricContext = metricContext;
    }

    public MonitoringConfig getMonitoringConfig() {
        return monitoringConfig;
    }

    public MetricContext getMetricContext() {
        return metricContext;
    }
}
