package ru.yandex.market.clickphite.monitoring;

import ru.yandex.market.monitoring.MonitoringStatus;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 08/09/15
 */
public class DataPoint {
    private final int timestampSeconds;
    private volatile long valueUpdateTime = -1;
    private volatile double value = Double.NaN;
    private volatile Status status = Status.NO_VALUE;

    public DataPoint(int timestampSeconds) {
        this.timestampSeconds = timestampSeconds;
    }

    public DataPoint(int timestampSeconds, double value) {
        this.timestampSeconds = timestampSeconds;
        setValue(value);
    }

    public int getTimestampSeconds() {
        return timestampSeconds;
    }

    public void setValue(double value, Status status) {
        valueUpdateTime = System.currentTimeMillis();
        this.status = status;
        this.value = value;
    }

    public double getValue() {
        return value;
    }

    public void setValue(double value) {
        setValue(value, Status.UNKNOWN);
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getValueUpdateTime() {
        return valueUpdateTime;
    }

    public Status getStatus() {
        return status;
    }

    public enum Status {
        NO_VALUE(null),
        UNKNOWN(null),
        OK(MonitoringStatus.OK),
        WARN(MonitoringStatus.WARNING),
        CRITICAL(MonitoringStatus.CRITICAL);

        private final MonitoringStatus monitoringStatus;

        Status(MonitoringStatus monitoringStatus) {
            this.monitoringStatus = monitoringStatus;
        }

        public MonitoringStatus getMonitoringStatus() {
            return monitoringStatus;
        }

        public boolean hasMonitoringStatus() {
            return monitoringStatus != null;
        }
    }

}
