package ru.yandex.market.clickphite.monitoring;

import com.google.common.base.Preconditions;
import ru.yandex.market.monitoring.MonitoringStatus;

import java.util.List;

/**
 * Статус мониторинга и набор точек, приведших к нему.
 */
public class MonitoringStatusAndCause {
    private final MonitoringStatus status;
    private final List<DataPoint> dataPoints;

    public MonitoringStatusAndCause(MonitoringStatus status, List<DataPoint> dataPoints) {
        this.status = Preconditions.checkNotNull(status, "status cannot be null");
        this.dataPoints = Preconditions.checkNotNull(dataPoints, "dataPoints cannot be null");
    }

    public MonitoringStatus getStatus() {
        return status;
    }

    public List<DataPoint> getDataPoints() {
        return dataPoints;
    }

    @Override
    public String toString() {
        return "MonitoringStatusAndCause{" +
                "status=" + status +
                ", dataPoints=" + dataPoints +
                '}';
    }
}
