package ru.yandex.market.clickphite.monitoring.kronos;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 28/10/15
 */
public class KronosModel {

    private final double[] extTop;
    private final double[] top;
    private final double[] average;
    private final double[] mean;
    private final double[] bottom;
    private final double[] extBottom;

    public KronosModel(double[] extTop, double[] top, double[] average,
                       double[] mean, double[] bottom, double[] extBottom) {
        this.extTop = extTop;
        this.top = top;
        this.average = average;
        this.mean = mean;
        this.bottom = bottom;
        this.extBottom = extBottom;
    }

    public int getSize() {
        return average.length;
    }

    public double getExtTop(int index) {
        return extTop[index];
    }

    public double getTop(int index) {
        return top[index];
    }

    public double getAverage(int index) {
        return average[index];
    }

    public double getMean(int index) {
        return mean[index];
    }

    public double getBottom(int index) {
        return bottom[index];
    }

    public double getExtBottom(int index) {
        return extBottom[index];
    }

    public double[] getExtTop() {
        return extTop;
    }

    public double[] getTop() {
        return top;
    }

    public double[] getAverage() {
        return average;
    }

    public double[] getMean() {
        return mean;
    }

    public double[] getBottom() {
        return bottom;
    }

    public double[] getExtBottom() {
        return extBottom;
    }
}
