package ru.yandex.market.clickphite.monitoring.razladki;

import ru.yandex.market.clickphite.config.monitoring.MonitoringConfig;
import ru.yandex.market.clickphite.graphite.Metric;
import ru.yandex.market.clickphite.metric.MetricContext;
import ru.yandex.market.clickphite.monitoring.DataPointList;

import java.util.concurrent.TimeUnit;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 09/09/15
 */
public class RazladkiCheckContext {

    private final MonitoringConfig monitoringConfig;
    private final MetricContext metricContext;

    private int sendDelaySeconds;
    private int lastSendTimeStampSeconds;

    private DataPointList sendDataPoints;
    private DataPointList actualValues;

    public RazladkiCheckContext(MonitoringConfig monitoringConfig, MetricContext metricContext) {
        this.monitoringConfig = monitoringConfig;
        this.metricContext = metricContext;

        int pointsCount = getPointsCount();
        actualValues = new DataPointList(pointsCount, metricContext.getPeriod().getDurationSeconds());
        sendDataPoints = new DataPointList(pointsCount, metricContext.getPeriod().getDurationSeconds());

    }

    private int getPointsCount() {
        int monitoringTimeSeconds = (int) TimeUnit.MINUTES.toSeconds(monitoringConfig.getCheckPoints() * 2);
        return monitoringTimeSeconds / metricContext.getPeriod().getDurationSeconds();
    }


    private void addData(Metric metric) {

    }

}
