package ru.yandex.market.clickphite.solomon;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 27.07.2018
 */
public class SolomonShardId {
    private final String project;
    private final String service;
    private final String cluster;

    public SolomonShardId(String project, String service, String cluster) {
        this.project = project;
        this.service = service;
        this.cluster = cluster;
    }

    public String getProject() {
        return project;
    }

    public String getService() {
        return service;
    }

    public String getCluster() {
        return cluster;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SolomonShardId that = (SolomonShardId) o;
        return project.equals(that.project)
            && service.equals(that.service)
            && cluster.equals(that.cluster);
    }

    @Override
    public int hashCode() {
        int result = project.hashCode();
        result = 31 * result + service.hashCode();
        result = 31 * result + cluster.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SolomonShard{" +
            "project='" + project + '\'' +
            ", service='" + service + '\'' +
            ", cluster='" + cluster + '\'' +
            '}';
    }
}
