package ru.yandex.market.clickphite.solomon.dto;

import com.google.gson.annotations.SerializedName;

import java.util.Collection;
import java.util.Map;

/**
 * https://wiki.yandex-team.ru/solomon/api/push/.
 * https://wiki.yandex-team.ru/solomon/api/dataformat/json/.
 *
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 18.07.2018
 */
public class SolomonPushRequestBody {
    @SerializedName("ts")
    private final Long commonTimestamp;
    private final Map<String, String> commonLabels;
    private final Collection<SolomonSensor> sensors;

    public SolomonPushRequestBody(
        Long commonTimestamp,
        Map<String, String> commonLabels,
        Collection<SolomonSensor> sensors
    ) {
        this.commonTimestamp = commonTimestamp;
        this.commonLabels = commonLabels;
        this.sensors = sensors;
    }

    public Long getCommonTimestamp() {
        return commonTimestamp;
    }

    public Map<String, String> getCommonLabels() {
        return commonLabels;
    }

    public Collection<SolomonSensor> getSensors() {
        return sensors;
    }
}
