package ru.yandex.market.clickphite.spring;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.yandex.market.health.HealthMetaDao;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 12.12.2018
 */
@Configuration
public class ClickphiteSpringMongoConfig {
    @Bean
    public HealthMetaDao healthMetaDao(
        @Value("${clickphite.mongo.url}") String mongoUrl,
        @Value("${clickphite.mongo.connect-timeout-millis}") int connectTimeoutMillis,
        @Value("${clickphite.mongo.socket-timeout-millis}") int socketTimeoutMillis,
        @Value("${clickphite.mongo.replica-set}") String replicaSet,
        @Value("${clickphite.mongo.ssl}") boolean ssl,
        @Value("${clickphite.mongo.db}") String dbName
    ) {
        return new HealthMetaDao(mongoUrl, dbName, connectTimeoutMillis, socketTimeoutMillis, replicaSet, ssl);
    }
}
