package ru.yandex.market.clickphite.worker;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.market.clickphite.ClickphiteService;
import ru.yandex.market.clickphite.ProcessStatus;
import ru.yandex.market.clickphite.metric.QueryWeight;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 20.09.17
 */
public abstract class Worker implements Runnable {
    private static final Logger log = LogManager.getLogger();

    private final ClickphiteService clickphiteService;
    private final ProcessStatus status;
    private final String workerName;

    Worker(ClickphiteService clickphiteService, ProcessStatus status, String workerName) {
        this.clickphiteService = clickphiteService;
        status.setOnAir(true);
        this.status = status;
        this.workerName = workerName;
    }

    @Override
    public void run() {
        try {
            if (!clickphiteService.isMaster()) {
                log.warn("Not master, not running:" + workerName);
                status.setOnAir(false);
                return;
            }
            doWork();
            status.setError(false);
            status.setException(null);
        } catch (Exception e) {
            log.error("Failed to run " + workerName, e);
            status.setError(true);
            status.setException(e);
        } catch (Throwable e) {
            log.fatal("Critical ERROR in worker " + workerName, e);
            System.exit(1);
        }
        status.setOnAir(false);
        status.setLastProcessTimeMillis(System.currentTimeMillis());

        statusUpdated();
    }

    public abstract void doWork() throws Exception;

    public abstract QueryWeight getQueryWeight();

    public ProcessStatus getStatus() {
        return status;
    }

    protected ClickphiteService getClickphiteService() {
        return clickphiteService;
    }

    protected void statusUpdated() {
    }
}
