#!/bin/sh
SERVANT=clickphite
USER=clickphite
LOG_RC=/var/log/$USER/$SERVANT.log.shell
LOG_GC=/var/log/$USER/$SERVANT.log.gc

JAVA_HOME=/usr/local/java8
PATH="$JAVA_HOME/bin:$PATH"


CLASSPATH=".:"`find /usr/lib/yandex/clickphite/ -name '*.jar' -printf '%p\n' | sort -r | tr '\n' ':'`

echo $SERVANT classpath is $CLASSPATH >> $LOG_RC

export PATH LANG JAVA_HOME CLASSPATH

cd /etc/yandex/$SERVANT

echo Started at `date` >> $LOG_RC

if [ -e /etc/yandex/environment.type ] ; then
    ENV_TYPE=$(cat /etc/yandex/environment.type)
    echo environment.type is $ENV_TYPE >> $LOG_RC
else
    echo Error: /etc/yandex/environment.type does not exists >> $LOG_RC
    exit 1
fi


HEAP_SIZE=16g

DEBUG="-Xdebug -Xverify:none -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=32145"
#DEBUG="-agentpath:/usr/bin/clickphite-libyjpagent.so=dir=/var/lib/yandex/clickphite/snapshots,port=32145"
if [ -e $LOG_GC ] ; then
    mv $LOG_GC $LOG_GC.1
fi

java -classpath $CLASSPATH $DEBUG \
     -Djava.net.preferIPv6Addresses=true \
     -Dsun.net.inetaddr.ttl=60 \
     -Dsun.net.inetaddr.negative.ttl=0 \
     -showversion -server \
     -Xmx$HEAP_SIZE -Xms$HEAP_SIZE -Xss2m -XX:PermSize=128m -XX:MaxPermSize=128m\
     -verbose:gc -XX:+PrintGC -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -XX:+PrintGCDateStamps -Xloggc:$LOG_GC \
     -XX:+UseCompressedOops \
     -XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=/var/log/$USER/hprof/ \
     -Dhost.name=`/bin/hostname` -Denvironment=$ENV_TYPE \
     -Dbean.file=clickphite.xml -Dmodule.properties.file=clickphite.properties \
     ru.yandex.market.log4j2.Main >> $LOG_RC 2>&1 &

echo $! > /var/run/$USER/$SERVANT.pid

