package ru.yandex.market;

import java.util.Calendar;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @author kukabara
 */
public class CalendarUtils {

    public static Calendar roundToModulo(Calendar calendar, int field, int value, boolean up) {
        calendar = round(calendar, field, up);
        int valuesCount = calendar.getMaximum(field) - calendar.getMinimum(field) + 1;
        int valueToAdd = up ? (valuesCount - calendar.get(field)) % value : -(calendar.get(field) % value);
        calendar.add(field, valueToAdd);
        return calendar;
    }

    public static Calendar round(Calendar calendar, int field, boolean up) {
        if (up) {
            return org.apache.commons.lang3.time.DateUtils.ceiling(calendar, field);
        } else {
            return org.apache.commons.lang3.time.DateUtils.truncate(calendar, field);
        }
    }
}
