package ru.yandex.market.clickhouse;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

/**
 * И все массивы, прилетевшие из кликхауса, станут строками.
 *
 * @author lemmsh
 * @since 7/25/14
 */
@Deprecated
public class ArrayToStringDeserializer extends JsonDeserializer<List<String>> {

    @Override
    public List<String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {

        JsonDeserializer<Object> deserializer = ctxt.findContextualValueDeserializer(
            TypeFactory.defaultInstance().constructType(new TypeReference<List<Object>>() {
            }),
            null
        );

        final Object deserialized = deserializer.deserialize(jp, ctxt);
        Preconditions.checkState(deserialized instanceof List);
        //noinspection unchecked
        final List<Object> deserializedList = (List) deserialized;

        List<String> result = new ArrayList<>(deserializedList.size());
        for (Object x : deserializedList) {
            if (x == null) {
                result.add(null);
            }
            if (x instanceof List) {
                try {
                    result.add(new ObjectMapper().writeValueAsString(x));
                } catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            } else {
                result.add(x.toString());
            }
        }
        return result;
    }


    public static <K, V> ConcurrentMap<K, V> newConcurrentWeakHashMap(boolean weakKeys, boolean weakValues) {
        MapMaker mapMaker = new MapMaker().concurrencyLevel(16);
        if (weakKeys) {
            mapMaker.weakKeys();
        }
        if (weakValues) {
            mapMaker.weakValues();
        }
        return mapMaker.makeMap();
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentWeakHashMap() {
        return newConcurrentWeakHashMap(true, true);
    }


}
