package ru.yandex.market.clickhouse;

import org.apache.log4j.Logger;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

/**
 * @author orantius
 * @version $Id$
 * @since 7/16/12
 */
@Deprecated
public class ByteFragment {
    static Logger log = Logger.getLogger(ByteFragment.class);

    private byte[] buf;
    private int start;
    private int len;
    private static final ByteFragment EMPTY = new ByteFragment(new byte[0], 0, 0);

    public ByteFragment(byte[] buf, int start, int len) {
        this.buf = buf;
        this.start = start;
        this.len = len;
    }

    public String asString() {
        return new String(buf, start, len, StandardCharsets.UTF_8);
    }

    public String asString(boolean unescape) {
        if (unescape) {
            return new String(unescape(), StandardCharsets.UTF_8);
        } else {
            return asString();
        }
    }

    @Override
    public String toString() {
        return "ByteFragment{" +
            "buf=" + Arrays.toString(buf) +
            ", start=" + start +
            ", len=" + len +
            '}';
    }

    public ByteFragment[] split(byte sep) {
        StreamSplitter ss = new StreamSplitter(this, sep);
        int c = count(sep) + 1;
        ByteFragment[] res = new ByteFragment[c];
        try {
            int i = 0;
            ByteFragment next = null;
            while ((next = ss.next()) != null) {
                res[i++] = next;
            }
        } catch (IOException ignore) {
        }
        if (res[c - 1] == null) {
            res[c - 1] = ByteFragment.EMPTY;
        }
        return res;
    }

    //  [45, 49, 57, 52, 49, 51, 56, 48, 57, 49, 52, 9, 9, 50, 48, 49, 50, 45, 48, 55, 45, 49, 55, 32, 49, 51, 58, 49, 50, 58, 50, 49, 9, 49, 50, 49, 50, 55, 53, 53, 9, 50, 57, 57, 57, 55, 55, 57, 57, 55, 56, 9, 48, 9, 52, 48, 57, 49, 57, 55, 52, 49, 49, 51, 50, 56, 53, 53, 50, 54, 57, 51, 9, 51, 9, 54, 9, 50, 48, 9, 48, 92, 48, 9, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 97, 118, 105, 116, 111, 46, 114, 117, 47, 99, 97, 116, 97, 108, 111, 103, 47, 103, 97, 114, 97, 122, 104, 105, 95, 105, 95, 109, 97, 115, 104, 105, 110, 111, 109, 101, 115, 116, 97, 45, 56, 53, 47, 116, 97, 116, 97, 114, 115, 116, 97, 110, 45, 54, 53, 48, 49, 51, 48, 47, 112, 97, 103, 101, 56, 9, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 97, 118, 105, 116, 111, 46, 114, 117, 47, 99, 97, 116, 97, 108, 111, 103, 47, 103, 97, 114, 97, 122, 104, 105, 95, 105, 95, 109, 97, 115, 104, 105, 110, 111, 109, 101, 115, 116, 97, 45, 56, 53, 47, 116, 97, 116, 97, 114, 115, 116, 97, 110, 45, 54, 53, 48, 49, 51, 48, 47, 112, 97, 103, 101, 55, 9, 48, 9, 48, 9, 50, 56, 53, 55, 48, 56, 48, 9, 45, 49, 9, 48, 9, 9, 48, 9, 48, 9, 48, 9, 45, 49, 9, 48, 48, 48, 48, 45, 48, 48, 45, 48, 48, 32, 48, 48, 58, 48, 48, 58, 48, 48, 9, 9, 48, 9, 48, 9, 103, 9, 45, 49, 9, 45, 49, 9, 45, 49, 9]
    public ByteArrayInputStream asStream() {
        return new ByteArrayInputStream(buf, start, len);
    }

    private int count(byte sep) {
        int res = 0;
        for (int i = start; i < start + len; i++) {
            if (buf[i] == sep) {
                res++;
            }
        }
        return res;
    }

    public int getLen() {
        return len;
    }


    //   2012.07.16 17:30:29 [spring-scheduler-3] DEBUG org.apache.http.wire - << "992541[0x9]1[0x9]0[0x9]8167885961324049050[0x9]5498583669064185695[0x9]1342427653[0x9]1342428010[0x9]4[0x9]http://e.mail.ru/cgi-bin/msglist[0x9]http://sewprice.ru/catg/gpg/otparivatel-dlja-odezhdy-Comfort-NV-338-gindex-881.html[0x9]http://sewprice.ru/content/akcii-cpg-113/[0x9]http://market.yandex.ru/grade-shop.xml?shop_id=4683&cmid=771006781&retpath1=http:%2F%2Fmarket.yandex.ru%2Fshop-opinions.xml%3Fshop_id%3D4683%26cmid%3D771006781[0x9]0[0x9]1[0x9]0[0x9][0x9]0[0x9]0[0x9][0x9][0xee][0xf6][0xb][0x1][0xd5][0xa4][0x8f][0x80][0x5]\0[0x9]2012-07-16 12:34:13[\n]" -- layer:5
    // 5498583669064185695
    // ��դ��\0  [0xee][0xf6][0xb][0x1][0xd5][0xa4][0x8f][0x80][0x5]\0
    //
    //int[]gg =  {0xee,0xf6,0x0b,0x01,0xd5,0xa4,0x8f,0x80,0x5,0x00};

    // "\0" =>  0
    // "\r" => 13
    // "\n" => 10
    // "\\" => 92
    // "\'" => 39
    // "\b" =>  8
    // "\f" => 12
    // "\t" =>  9
    private static final byte[] convert = {
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,      // 0.. 9
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,      //10..19
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,      //20..29
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 39,      //30..39
        -1, -1, -1, -1, -1, -1, -1, -1, 0, -1,      //40..49
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,      //50..59
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,      //60..69
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,      //70..79
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,      //80..89
        -1, -1, 92, -1, -1, -1, -1, -1, 8, -1,      //90..99
        -1, -1, 12, -1, -1, -1, -1, -1, -1, -1,     //100..109
        10, -1, -1, -1, 13, -1, 9, -1, -1, -1,     //110..119
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,     //120..129
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    };
    // [0xb6][0xfe][0x7][0x1][0xd8][0xd6][0x94][0x80][0x5]\0   html.
    //  [-74,-2,7,1,-40,-42,-108,-128,5,0]   real value
    //  [-74,-2,7,1,-40,-42,-108,-128,5,92,48]   parsed value

    public byte[] unescape() {
        int resLen = 0;
        {
            boolean prevSlash = false;
            for (int i = start; i < start + len; i++) {
                if (prevSlash) {
                    resLen++;
                    prevSlash = false;
                } else {
                    if (buf[i] == 92) { // slash character
                        prevSlash = true;
                    } else {
                        resLen++;
                    }
                }
            }
        }
        if (resLen == len) {
            return getBytesCopy();
        }
        byte[] res = new byte[resLen];
        int index = 0;
        {
            boolean prevSlash = false;
            for (int i = start; i < start + len; i++) {
                if (prevSlash) {
                    prevSlash = false;
                    if (buf[i] != 48 && buf[i] != 110 && buf[i] != 114 && buf[i] != 92
                        && buf[i] != 39 && buf[i] != 98 && buf[i] != 102 && buf[i] != 116) {
                        log.error("FAIL");
                    }

                    res[index++] = convert[buf[i]];

                } else {
                    if (buf[i] == 92) { // slash character
                        prevSlash = true;
                    } else {
                        res[index++] = buf[i];
                    }
                }

            }
        }
        return res;
    }

    private byte[] getBytesCopy() {
        byte[] bytes = new byte[len];
        System.arraycopy(buf, start, bytes, 0, len);
        return bytes;
    }

    public int length() {
        return len;
    }

    public int charAt(int i) {
        return buf[start + i];
    }
}
