package ru.yandex.market.clickhouse;

//import ru.yandex.metrika.util.route.RouteConfigSimple;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

/**
 * datasource
 *
 * @author orantius
 * @version $Id$
 * @since 7/12/12
 */
@Deprecated
public class ClickHouseSource {
    private static final int DEFAULT_PORT = 8123;

    private List<String> hosts = Collections.singletonList("localhost");
    private Multimap<Integer, String> shard2Hosts;
    private String slbHost;
    private int port = DEFAULT_PORT;
    private String user = null;
    private String passwd = null;
    private String authInfo;
    private String cluster;
    private String database;
    private boolean replicated = false;
    private String ddlApplyCluster;
    private boolean ssl = false;

    public ClickHouseSource() {
    }

    public ClickHouseSource(String hosts, String database) {
        setHost(hosts);
        this.database = database;
    }

    public ClickHouseSource(String hosts, String database, String user) {
        setHost(hosts);
        this.database = database;
        this.user = user;
        updateAuthInfo();
    }

    public ClickHouseSource(String hosts, int port) {
        setHost(hosts);
        this.port = port;
    }

    public ClickHouseSource(String hosts, int port, String database) {
        setHost(hosts);
        this.port = port;
        this.database = database;
    }

    public ClickHouseSource(String database) {
        this.database = database;
    }

    public void setHost(String hosts) {
        if (hosts.contains(",")) {
            String[] splits = hosts.split(",");
            this.hosts = new ArrayList<>(splits.length);
            for (String split : splits) {
                this.hosts.add(split);
            }
        } else {
            this.hosts = Collections.singletonList(hosts);
        }
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public void setShard2Hosts(Multimap<Integer, String> shard2Hosts) {
        this.shard2Hosts = shard2Hosts;
    }

    public boolean isDistributed() {
        return cluster != null;
    }

    public List<String> getHosts() {
        return hosts;
    }

    public Multimap<Integer, String> getShard2Hosts() {
        return shard2Hosts;
    }

    private String selectHost() {
        if (slbHost != null) {
            return slbHost;
        }

        if (hosts.size() > 1) {
            int number = ThreadLocalRandom.current().nextInt(hosts.size());
            return hosts.get(number);
        } else {
            return hosts.get(0);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDb(String database) {
        this.database = database;
    }

    public String getHost() {
        return selectHost();
    }

    public int getPort() {
        return port;
    }

    public String getDb() {
        return database;
    }

    public String getUser() {
        return user;
    }

    public String getScheme() {
        return ssl ? "https" : "http";
    }

    public void setUser(String user) {
        this.user = user;
        updateAuthInfo();
    }

    public boolean isReplicated() {
        return replicated;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    public String getPasswd() {
        return passwd;
    }

    public void setPasswd(String passwd) {
        if (Strings.isNullOrEmpty(passwd)) {
            return;
        }
        this.passwd = passwd;
        updateAuthInfo();
    }

    public void setCluster(String cluster) {
        if (cluster == null || cluster.trim().isEmpty()) {
            this.cluster = null;
        } else {
            this.cluster = cluster;
        }
    }

    public void setDdlApplyCluster(String ddlApplyCluster) {
        if (ddlApplyCluster == null || ddlApplyCluster.trim().isEmpty()) {
            this.ddlApplyCluster = null;
        } else {
            this.ddlApplyCluster = ddlApplyCluster;
        }
    }

    public void setSlbHost(String slbHost) {
        if (slbHost == null || slbHost.trim().isEmpty()) {
            this.slbHost = null;
        } else {
            this.slbHost = slbHost;
        }
    }

    public String getCluster() {
        return cluster;
    }


    public String getDdlApplyCluster() {
        return ddlApplyCluster == null ? cluster : ddlApplyCluster;
    }

    private void updateAuthInfo() {
        authInfo = null;
        if (user != null && !user.isEmpty()) {
            authInfo = user + ":";
            if (passwd != null) {
                authInfo += passwd;
            }
        }
    }

    public String getAuthInfo() {
        return authInfo;
    }

    public boolean isSsl() {
        return ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ClickHouseSource source = (ClickHouseSource) o;
        if (database != null ? !database.equals(source.database) : source.database != null) {
            return false;
        }
        if (slbHost != null ? !slbHost.equals(source.slbHost) : source.database != null) {
            return false;
        }
        return port == source.port && hosts.equals(source.hosts);
    }

    @Override
    public int hashCode() {
        int result = hosts.hashCode();
        result = 31 * result + port;
        result = 31 * result + (slbHost != null ? slbHost.hashCode() : 0);
        result = 31 * result + (database != null ? database.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ClickHouseSource{" +
            "slbHost='" + slbHost + '\'' +
            ", hosts=" + hosts +
            ", port=" + port +
            ", database='" + database + '\'' +
            '}';
    }

}
