package ru.yandex.market.clickhouse;

import com.google.common.io.CountingInputStream;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

/**
 * формат полей.
 * 0000-00-00 00:00:00 - timestamp
 * \0 - null?
 * <p/>
 * запросы, которые работают
 * select * from WatchLog_Chunk_2012071003020404100 limit 10
 * show tables
 *
 * @author orantius
 * @version $Id$
 * @since 7/12/12
 */
@Deprecated
public class HttpResult extends AbstractResultSet {

    private static final Pattern TABS = Pattern.compile("\t");

    private ByteFragment nextLine;
    private final StreamSplitter bis;
    private ByteFragment headerFragment;

    private final Map<String, Integer> col = new HashMap<>(); // column name -> 1-based index
    private final String[] columns;
    private final String[] types;
    // number of characters readFile from is stream
    private long bytes = 0;
    private CountingInputStream cis;

    public HttpResult(InputStream is, CountingInputStream cis, int bufferSize) throws IOException {
        this.cis = cis;
        bis = new StreamSplitter(is, (byte) 0x0A, bufferSize);  ///   \n
        headerFragment = bis.next();
        if (headerFragment == null) {
            throw new IllegalArgumentException("clickhouse response without column names");
        }
        String header = headerFragment.asString();
        if (header.startsWith("Code: ") && !header.contains("\t")) {
            is.close();
            throw new IOException("Clickhouse error: " + header);
        }
        columns = TABS.split(header);
        ByteFragment typesFragment = bis.next();
        types = typesFragment != null ? TABS.split(typesFragment.asString()) : new String[0];

        for (int i = 0; i < columns.length; i++) {
            String s = columns[i];
            col.put(s, i + 1);
        }
    }

    public boolean hasNext() throws SQLException {
        if (nextLine == null) {
            try {
                nextLine = bis.next();
                if (nextLine == null || nextLine.length() == 0) {
                    bis.close();
                } else {
                    bytes += nextLine.getLen();
                }
            } catch (IOException e) {
                throw new SQLException(e);
            }
        }
        return nextLine != null && nextLine.length() > 0;
    }

    public HttpResultRow getNext() throws SQLException {
        if (hasNext()) {
            HttpResultRow res = new HttpResultRow(this, nextLine);
            nextLine = null;
            return res;
        } else {
            throw new NoSuchElementException("end of result set, check hasNext() before calling getNext() ");
        }
    }

    public void close() throws SQLException {
        try {
            bis.close();
        } catch (IOException e) {
            throw new SQLException(e);
        }
    }

    /////////////////////////////////////////////////////////

    String[] getTypes() {
        return types;
    }

    ByteFragment getHeaderFragment() {
        return headerFragment;
    }

    String[] getColumnNames() {
        return columns;
    }

    Map<String, Integer> getCol() {
        return col;
    }

    /////////////////////////////////////////////////////////

    public long getReadBytes() {
        return bytes;
    }

    public long getRecievedBytes() {
        return cis.getCount();
    }

    public static void main(String[] args) {
        ByteFragment value = new ByteFragment(new byte[]{(int) '-', 0x31, 0x32, 0x33, 0x34}, 1, 4);
        long i2 = ByteFragmentUtils.parseLong(value);
        System.out.println("i2 = " + i2);
    }


}
