package ru.yandex.market.clickhouse;


import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;

/**
 * формат полей.
 * 0000-00-00 00:00:00 - timestamp
 * \0 - null?
 * <p>
 * запросы, которые работают
 * select * from WatchLog_Chunk_2012071003020404100 limit 10
 * show tables
 *
 * @author orantius
 * @version $Id$
 * @since 7/12/12
 */
@Deprecated
public class HttpResultRow extends AbstractResultSet {

    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); //
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd"); //

    private final HttpResult resultSetMetadata;
    private final ByteFragment nextLine;
    private ByteFragment[] values;

    public HttpResultRow(HttpResult resultSetMetadata, ByteFragment nextLine) {
        this.resultSetMetadata = resultSetMetadata;
        this.nextLine = nextLine;
    }

    // ЕСЛИ values БРОСИЛ NPE, ЗНАЧИТ ЗАБЫЛИ split()
    // split отложен за пределы конструктора, т.к. чтение выполняется в один поток, а rowmapper может быть вызван параллельно на списке HRR.
    public HttpResultRow split() {
        values = nextLine.split((byte) 0x09);
        return this;
    }

    /////////////////////////////////////////////////////////


    public int getInt(String column) {
        return getInt(asColNum(column));
    }


    public boolean getBoolean(String column) {
        return getBoolean(asColNum(column));
    }


    public long getLong(String column) {
        return getLong(asColNum(column));
    }


    public String getString(String column) {
        return getString(asColNum(column));
    }


    public byte[] getBytes(String column) {
        return getBytes(asColNum(column));
    }

    public long getTimestampAsLong(String column) {
        return getTimestampAsLong(asColNum(column));
    }


    public Timestamp getTimestamp(String column) throws SQLException {
        return new Timestamp(getTimestampAsLong(column));
    }


    public short getShort(String column) {
        return getShort(asColNum(column));
    }


    public byte getByte(String column) {
        return getByte(asColNum(column));
    }

    /////////////////////////////////////////////////////////


    public String getString(int colNum) {
        return toString(values[colNum - 1]);
    }

    public double[] getDoubleArray(String column) {
        return getDoubleArray(asColNum(column));
    }

    public double[] getDoubleArray(int colNum) {
        String string = getString(colNum);
        string = string.substring(1, string.length() - 1);
        String[] splits = string.split(",");
        double[] values = new double[splits.length];
        for (int i = 0; i < splits.length; i++) {
            values[i] = toDouble(splits[i]);
        }
        return values;
    }


    public int getInt(int colNum) {
        return ByteFragmentUtils.parseInt(values[colNum - 1]);
    }


    public boolean getBoolean(int colNum) {
        return toBoolean(values[colNum - 1]);
    }


    public long getLong(int colNum) {
        return ByteFragmentUtils.parseLong(values[colNum - 1]);
    }


    public byte[] getBytes(int colNum) {
        return toBytes(values[colNum - 1]);
    }

    public long getTimestampAsLong(int colNum) {
        return toTimestamp(values[colNum - 1]);
    }


    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return new Timestamp(getTimestampAsLong(columnIndex));
    }


    public short getShort(int colNum) {
        return toShort(values[colNum - 1]);
    }


    public byte getByte(int colNum) {
        return toByte(values[colNum - 1]);
    }

    @Override
    public double getDouble(String columnLabel) {
        return getDouble(asColNum(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) {
        return toDouble(values[columnIndex - 1]);
    }

//
//    @Override
//    public Date getDate(int columnIndex) throws SQLException {
//        return toDate(values[columnIndex - 1]);
//    }
//
//    @Override
//    public Date getDate(String columnLabel) throws SQLException {
//        return getDate(asColNum(columnLabel));
//    }

    /////////////////////////////////////////////////////////

    private static byte toByte(ByteFragment value) {
        return Byte.parseByte(value.asString());
    }

    private static short toShort(ByteFragment value) {
        return Short.parseShort(value.asString());
    }

    private static boolean toBoolean(ByteFragment value) {
        return "1".equals(value.asString());    //вроде бы там   1/0
    }

    private static byte[] toBytes(ByteFragment value) {
        return value.unescape();
    }

    private static String toString(ByteFragment value) {
        return value.asString(true);
    }

    private static int toInt(ByteFragment value) {
        return Integer.parseInt(value.asString());
    }

    private static long toLong(ByteFragment value) {
        String s = value.asString();
        if (s.length() >= "9223372036854775808".length()) {
            BigInteger bi = new BigInteger(s);
            return bi.longValue();
        }
        return Long.parseLong(s);
    }

    public static double toDouble(ByteFragment value) {
        return toDouble(value.asString());

    }

    public static double toDouble(String string) {
        switch (string) {
            case "nan":
                return Double.NaN;
            case "+inf":
            case "inf":
                return Double.POSITIVE_INFINITY;
            case "-inf":
                return Double.NEGATIVE_INFINITY;
            default:
                return Double.parseDouble(string);
        }
    }

    // 0000-00-00 00:00:00
    private synchronized long toTimestamp(ByteFragment value) {
        try {
            return dateTimeFormat.parse(value.asString()).getTime();
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

//    private synchronized Date toDate(ByteFragment value) throws SQLException {
//        try {
//            return dateFormat.parse(value.asString());
//        } catch (ParseException e) {
//            throw new SQLException("Failed to parse date: " + value.asString(), e);
//        }
//    }

    // 1-based insex in column list
    private int asColNum(String column) {
        if (resultSetMetadata.getCol().containsKey(column)) {
            return resultSetMetadata.getCol().get(column);
        } else {
            throw new RuntimeException("no column " + column + " in columns list " + Arrays.toString(resultSetMetadata.getColumnNames()));
        }
    }

}
