package ru.yandex.market.clickhouse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.RowMapper;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 * Итератор по ResultSet-у. Каждая прочитанная из ResultSet строка преобразуется с помощью RowMapper в объект и
 * отдается наружу. Итератор надо или явным образом закрыть после использования, или дочитать до конца, в противном случае
 * останется незакрытый ResultSet.
 *
 * @param <T>
 */
@Deprecated
public class IterableHttpResult<T> implements Iterable<T> {

    static Logger log = LoggerFactory.getLogger(IterableHttpResult.class);

    private final ClickhouseTemplate ds;
    HttpResult resultSet;
    private final String sql;
    private final RowMapper<T> rowMapper;
    private final Object[] params;
    private final int[] types;

    private Iterator<T> it;
    private int count;

    private long uncompressedSize;
    private long compressedSize;

    IterableHttpResult(ClickhouseTemplate ds, String sql, RowMapper<T> rowMapper, Object[] params, int[] types) {
        this.ds = ds;
        this.sql = sql;
        this.rowMapper = rowMapper;
        this.params = params;
        this.types = types;
    }

    public long getUncompressedSize() {
        if (resultSet != null) {
            return resultSet.getReadBytes();
        } else {
            return uncompressedSize;
        }
    }

    public long getCompressedSize() {
        if (resultSet != null) {
            return resultSet.getRecievedBytes();
        } else {
            return compressedSize;
        }
    }

    public void close() {
        if (log.isDebugEnabled()) {
            log.debug("closing result set, {} records processed. query was: {}", count, sql);
        }
        if (resultSet != null) {
            try {
                uncompressedSize = resultSet.getReadBytes();
                compressedSize = resultSet.getRecievedBytes();
                resultSet.close();
                resultSet = null;
            } catch (Exception e) {
                log.warn("Error closing IterableResultSet", e);
            }
        }
    }

    @SuppressWarnings({"JDBCResourceOpenedButNotSafelyClosed"})
    @Override
    public Iterator<T> iterator() {
        if (it != null) {
            throw new IllegalStateException("iterator opened two times");
        }
        try {
            resultSet = ds.getHttpResult(sql);
        } catch (IOException e) {
            close();
            throw new RuntimeException("Error iterating resultset", e);
        }

        it = new Iterator<T>() {
            private boolean hasNext;
            private T nextRow;

            {
                goToNext();
            }

            private void goToNext() {
                try {
                    hasNext = resultSet.hasNext();
                    if (hasNext) {
                        count++;
                        HttpResultRow next = resultSet.getNext();
                        nextRow = rowMapper.mapRow(next.split(), count);
                    } else {
                        close();
                    }
                } catch (SQLException e) {
                    close();
                    throw new UncategorizedSQLException("goToNext", sql, e);
                } catch (Exception e) {
                    close();
                    throw new IllegalStateException("error map row", e);
                }
            }

            @Override
            public boolean hasNext() {
                return hasNext;
            }

            @Override
            public T next() {
                if (!hasNext) {
                    throw new NoSuchElementException("next() called and hasNext==false");
                }
                T result = nextRow;
                goToNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("noway");
            }
        };
        return it;
    }

    public boolean hasNext() {
        return it == null || it.hasNext();
    }
}
