package ru.yandex.market.clickhouse.ddl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.market.clickhouse.ClickHouseSource;
import ru.yandex.market.clickhouse.ClickhouseTemplate;

import java.util.Optional;

/**
 * @author galaev@yandex-team.ru
 * @since 04/10/16.
 */
@Deprecated
public class ClickHouseDdlServiceOld {
    private static final Logger log = LogManager.getLogger();

    private ClickHouseSource clickHouseSource;
    private ClickhouseTemplate clickhouseTemplate;

    /**
     * Получить ddl по имени и описанию таблицы.
     */
    public DDL getDDL(ClickHouseTableDefinition tableDefinition, String host) {
        return TableUtils.buildDDL(
            tableDefinition,
            Optional.ofNullable(getTableDDL(tableDefinition.getFullTableName(), host)),
            host
        );
    }

    public void executeManualDDL(DDL ddl) {
        for (DdlQuery query : ddl.getManualUpdates()) {
            log.info("Executing manual DDL query: " + query.getQueryString());
            clickhouseTemplate.update(query.getQueryString(), ddl.getHost());
        }
    }

    public boolean isReplicated() {
        return clickHouseSource.isReplicated();
    }

    public boolean isDistributed() {
        return clickHouseSource.isDistributed();
    }

    public String getCluster() {
        return clickHouseSource.getCluster();
    }

    private String getTableDDL(String fullTableName, String host) {
        boolean tableExists = clickhouseTemplate.queryForInt("EXISTS TABLE " + fullTableName, host) > 0;
        return tableExists ? getExistedTableDDL(fullTableName, host) : null;
    }

    private String getExistedTableDDL(String tableName, String host) {
        return clickhouseTemplate.queryForString("SHOW CREATE TABLE " + tableName, host);
    }

    @Required
    public void setClickhouseTemplate(ClickhouseTemplate clickhouseTemplate) {
        this.clickhouseTemplate = clickhouseTemplate;
    }

    @Required
    public void setClickHouseSource(ClickHouseSource clickHouseSource) {
        this.clickHouseSource = clickHouseSource;
    }

}
