package ru.yandex.market.clickhouse.ddl;

import ru.yandex.market.clickhouse.ddl.engine.EngineType;

import java.util.List;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 27/03/2018
 */
public interface ClickHouseTableDefinition {

    String getDatabaseName();

    String getTableName();

    String getFullTableName();

    List<Column> getColumns();

    EngineType getEngine();

    default Column getColumn(String columnName) {
        return getColumns().stream().filter(c -> c.getName().equals(columnName)).findFirst().get();
    }
}
