package ru.yandex.market.clickhouse.ddl;

import ru.yandex.market.clickhouse.ddl.engine.EngineType;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 27/03/2018
 */
public class ClickHouseTableDefinitionImpl implements ClickHouseTableDefinition {

    private final TableName tableName;
    private final List<Column> columns;
    private final EngineType engine;

    public ClickHouseTableDefinitionImpl(TableName tableName, List<Column> columns, EngineType engine) {
        this.tableName = tableName;
        this.columns = Collections.unmodifiableList(columns);
        this.engine = engine;
    }

    public ClickHouseTableDefinitionImpl(String fullTableName, List<Column> columns, EngineType engine) {
        this(new TableName(fullTableName), columns, engine);
    }

    public ClickHouseTableDefinitionImpl(String databaseName, String tableName,
                                         List<Column> columns, EngineType engine) {
        this(new TableName(databaseName, tableName), columns, engine);
    }

    @Override
    public String getDatabaseName() {
        return tableName.getDatabase();
    }

    @Override
    public String getTableName() {
        return tableName.getTable();
    }

    @Override
    public String getFullTableName() {
        return tableName.getFullName();
    }

    @Override
    public List<Column> getColumns() {
        return columns;
    }

    @Override
    public EngineType getEngine() {
        return engine;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClickHouseTableDefinitionImpl that = (ClickHouseTableDefinitionImpl) o;
        return Objects.equals(tableName, that.tableName) &&
            Objects.equals(columns, that.columns) &&
            Objects.equals(engine, that.engine);
    }

    @Override
    public int hashCode() {

        return Objects.hash(tableName, columns, engine);
    }

    @Override
    public String toString() {
        return "ClickHouseTableDefinitionImpl{" +
            "tableName=" + tableName +
            ", columns=" + columns +
            ", engine=" + engine +
            '}';
    }
}
