package ru.yandex.market.clickhouse.ddl;

import ru.yandex.market.clickhouse.ddl.enums.EnumArrayColumnType;
import ru.yandex.market.clickhouse.ddl.enums.EnumColumnType;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 18/08/16
 */
public class ColumnTypeUtils {
    private ColumnTypeUtils() {
    }

    public static ColumnTypeBase fromClickhouseDDL(String name) {
        if (name != null && name.startsWith("Array(Enum")) {
            return EnumArrayColumnType.fromClickhouseDDL(name);
        } if (name != null && name.startsWith("Array(")) {
            String subtype = name.substring("Array(".length(), name.lastIndexOf(")"));
            return ColumnType.valueOf("Array" + subtype);
        } if (name != null && name.startsWith("Nullable(")) {
            String subtype = name.substring("Nullable(".length(), name.lastIndexOf(")"));
            return ColumnType.valueOf("Nullable" + subtype);
        } else if (name != null && name.startsWith("Enum")) {
            return EnumColumnType.fromClickhouseDDL(name);
        }

        return ColumnType.valueOf(name);
    }
}
