package ru.yandex.market.clickhouse.ddl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Содержит набор изменений, которые нужно применить к определённому хосту, чтобы привести таблицу к нужному состоянию.
 *
 * @author Tatiana Litvinenko <a href="mailto:tanlit@yandex-team.ru"></a>
 * @date 29.05.2015
 */
public class DDL { //TODO отрефакторить
    private final String host;
    private final List<DdlQuery> updates = new ArrayList<>();
    private final List<DdlQuery> manualUpdates = new ArrayList<>();
    private final List<String> errors = new ArrayList<>();

    public DDL(String host) {
        this.host = host;
    }

    public boolean requireAttention() {
        return !manualUpdates.isEmpty() || !errors.isEmpty();
    }

    public void addQuery(DdlQuery query) {
        updates.add(query);
    }

    public void addManualQuery(DdlQuery query) {
        manualUpdates.add(query);
    }

    public void addError(String query) {
        errors.add(query);
    }

    public List<DdlQuery> getUpdates() {
        return updates;
    }

    public List<DdlQuery> getManualUpdates() {
        return manualUpdates;
    }

    public List<String> getErrors() {
        return errors;
    }

    @Override
    public String toString() {
        return "DDL{" +
            "host='" + host + '\'' +
            ", updates=" + updates +
            ", manualUpdates=" + manualUpdates +
            ", errors=" + errors +
            '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DDL ddl = (DDL) o;
        return Objects.equal(host, ddl.host) &&
            Objects.equal(updates, ddl.updates) &&
            Objects.equal(manualUpdates, ddl.manualUpdates) &&
            Objects.equal(errors, ddl.errors);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(host, updates, manualUpdates, errors);
    }

    public void add(DDL otherDDL) {
        Preconditions.checkArgument(this.getHost().equals(otherDDL.getHost()));

        this.updates.addAll(otherDDL.updates);
        this.manualUpdates.addAll(otherDDL.manualUpdates);
        this.errors.addAll(otherDDL.errors);
    }

    public String getHost() {
        return host;
    }
}
