package ru.yandex.market.clickhouse.ddl;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 08.11.16
 */
public class DdlQuery {
    private final DdlQueryType type;
    private final String query;

    public DdlQuery(DdlQueryType type, String query) {
        this.type = type;
        this.query = query;
    }

    public DdlQueryType getType() {
        return type;
    }

    public String getQueryString() {
        return query;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DdlQuery ddlQuery = (DdlQuery) o;

        if (type != ddlQuery.type) {
            return false;
        }
        return query != null ? query.equals(ddlQuery.query) : ddlQuery.query == null;

    }

    @Override
    public int hashCode() {
        int result = type != null ? type.ordinal() : 0;
        result = 31 * result + (query != null ? query.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "DdlQuery{" +
            "type=" + type +
            ", query='" + query + '\'' +
            '}';
    }
}
