package ru.yandex.market.clickhouse.ddl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

import java.util.Objects;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 07/06/2018
 */
public class TableName {
    private final String database;
    private final String table;
    private final String fullName;

    public TableName(String database, String table) {
        this.database = database;
        this.table = table;
        fullName = database + "." + table;
        validate();
    }

    public TableName(String fullName) {
        this.fullName = fullName;
        String[] splits = fullName.split("\\.", 2);
        database = splits[0];
        table = splits[1];
        validate();
    }

    private void validate(){
        Preconditions.checkArgument(!Strings.isNullOrEmpty(database));
        Preconditions.checkArgument(!Strings.isNullOrEmpty(table));
    }

    public TableName withTablePostfix(String tablePostfix) {
        return new TableName(
            database,
            table + tablePostfix
        );
    }

    public String getDatabase() {
        return database;
    }

    public String getTable() {
        return table;
    }

    public String getFullName() {
        return fullName;
    }

    @Override
    public String toString() {
        return fullName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TableName tableName = (TableName) o;
        return Objects.equals(database, tableName.database) &&
            Objects.equals(table, tableName.table) &&
            Objects.equals(fullName, tableName.fullName);
    }

    @Override
    public int hashCode() {

        return Objects.hash(database, table, fullName);
    }
}
