package ru.yandex.market.clickhouse.ddl.engine;

import ru.yandex.market.clickhouse.ddl.TableName;

import java.util.Objects;

/**
 * @author Tatiana Litvinenko <a href="mailto:tanlit@yandex-team.ru"></a>
 * @date 28.05.2015
 */
public class DistributedEngine implements EngineType {

    private final String cluster;
    private final TableName dataTableName;
    private final String shardingKey;

    public DistributedEngine(String cluster, TableName dataTableName, String shardingKey) {
        this.cluster = cluster;
        this.dataTableName = dataTableName;
        this.shardingKey = shardingKey;
    }

    public DistributedEngine(String cluster, TableName dataTableName) {
        this(cluster, dataTableName, null);
    }

    public DistributedEngine(String cluster, String database, String table, String shardingKey) {
        this(cluster, new TableName(database, table), shardingKey);
    }

    @Override
    public String createEngineDDL() {
        if (shardingKey != null) {
            return String.format(
                "Distributed(%s, %s, %s, %s)",
                cluster, dataTableName.getDatabase(), dataTableName.getTable(), shardingKey
            );
        } else {
            return String.format(
                "Distributed(%s, %s, %s)", cluster, dataTableName.getDatabase(), dataTableName.getTable()
            );
        }
    }

    @Override
    public EngineType replicated(String database, String table, String zkTablePrefix) {
        throw new UnsupportedOperationException("Distributed engine cannot be replicated");
    }

    @Override
    public boolean containsColumn(String columnName) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DistributedEngine that = (DistributedEngine) o;
        return Objects.equals(cluster, that.cluster) &&
            Objects.equals(dataTableName, that.dataTableName) &&
            Objects.equals(shardingKey, that.shardingKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cluster, dataTableName, shardingKey);
    }

    @Override
    public String toString() {
        return "DistributedEngine{" +
            "cluster='" + cluster + '\'' +
            ", dataTableName=" + dataTableName +
            ", shardingKey='" + shardingKey + '\'' +
            '}';
    }
}
