package ru.yandex.market.clickhouse.ddl.engine;

import ru.yandex.market.clickhouse.ddl.TableName;

/**
 * @author Tatiana Litvinenko <a href="mailto:tanlit@yandex-team.ru"></a>
 * @date 26.05.2015
 */
public interface EngineType {
    boolean containsColumn(String columnName);

    String createEngineDDL();

    EngineType replicated(String database, String table, String zkTablePrefix);

    default EngineType replicated(TableName tableName, String zkTablePrefix) {
        return replicated(tableName.getDatabase(), tableName.getTable(), zkTablePrefix);
    }
}
