package ru.yandex.market.clickhouse.ddl.engine;

import java.util.List;
import java.util.Objects;

public class ReplacingMergeTree extends MergeTree {
    protected final String versionColumnName;

    public ReplacingMergeTree(MergeTree mergeTree, String versionColumnName) {
        super(mergeTree);
        this.versionColumnName = versionColumnName;
    }

    public ReplacingMergeTree(
        String versionColumnName, String partitionBy, List<String> orderBy, String sampleBy, int indexGranularity) {
        super(partitionBy, orderBy, sampleBy, indexGranularity);
        this.versionColumnName = versionColumnName;
    }

    public ReplacingMergeTree(String versionColumnName, String partitionBy, List<String> orderBy, String sampleBy) {
        super(partitionBy, orderBy, sampleBy);
        this.versionColumnName = versionColumnName;
    }

    public ReplacingMergeTree(String versionColumnName, String partitionBy, List<String> orderBy) {
        super(partitionBy, orderBy);
        this.versionColumnName = versionColumnName;
    }

    public ReplacingMergeTree(MergeTree mergeTree) {
        this(mergeTree, null);
    }

    public ReplacingMergeTree(String partitionBy, List<String> orderBy, String sampleBy, int indexGranularity) {
        this(null, partitionBy, orderBy, sampleBy, indexGranularity);
    }

    public ReplacingMergeTree(String partitionBy, List<String> orderBy, String sampleBy) {
        this(null, partitionBy, orderBy, sampleBy);
    }

    public ReplacingMergeTree(String partitionBy, List<String> orderBy) {
        this(null, partitionBy, orderBy);
    }

    public String getEngineTypeName() {
        return "ReplacingMergeTree";
    }

    public String getEngineParams() {
        if (versionColumnName == null) {
            return "";
        } else {
            return versionColumnName;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplacingMergeTree)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplacingMergeTree that = (ReplacingMergeTree) o;
        return Objects.equals(versionColumnName, that.versionColumnName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), versionColumnName);
    }

    @Override
    public String toString() {
        return "ReplacingMergeTree{" +
            "versionColumnName='" + versionColumnName + '\'' +
            "partitionBy='" + getPartitionBy() + '\'' +
            ", orderBy=" + getOrderBy() +
            ", sampleBy='" + getSampleBy() + '\'' +
            ", indexGranularity=" + getIndexGranularity() +
            '}';
    }
}
