package ru.yandex.market.clickhouse.ddl.enums;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 18/08/16
 */
class EnumConstant {
    private final String name;
    private final int ordinal;

    EnumConstant(String name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
    }

    public static EnumConstant fromClickhouseDDL(String string) {
        String[] parts = string.split("=");
        String name = parts[0].trim().replace("'", "");
        int ordinal = Integer.parseInt(parts[1].trim());
        return new EnumConstant(name, ordinal);
    }

    public String getName() {
        return name;
    }

    public int getOrdinal() {
        return ordinal;
    }

    @Override
    public String toString() {
        return String.format("'%s' = %d", name, ordinal);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        EnumConstant that = (EnumConstant) o;

        if (ordinal != that.ordinal) {
            return false;
        }

        return name != null ? name.equals(that.name) : that.name == null;
    }

    @Override
    public int hashCode() {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + ordinal;
        return result;
    }
}
