package ru.yandex.market.conductor.model;


import com.google.gson.annotations.SerializedName;

/**
 * @author kukabara
 */
public class ConductorPackage {
    @SerializedName("package")
    String packageName;
    String version;

    public ConductorPackage(String packageName, String version) {
        this.packageName = packageName;
        this.version = version;
    }

    public String getPackageName() {
        return packageName;
    }

    public String getVersion() {
        return version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConductorPackage)) {
            return false;
        }

        ConductorPackage that = (ConductorPackage) o;

        if (packageName != null ? !packageName.equals(that.packageName) : that.packageName != null) {
            return false;
        }
        return !(version != null ? !version.equals(that.version) : that.version != null);

    }

    @Override
    public int hashCode() {
        int result = packageName != null ? packageName.hashCode() : 0;
        result = 31 * result + (version != null ? version.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ConductorPackage{" +
            "packageName='" + packageName + '\'' +
            ", version='" + version + '\'' +
            '}';
    }
}
