package ru.yandex.market.conductor.model;

import java.util.Date;
import java.util.List;

/**
 * ticket = 709960
 * project = CS
 * name = CS-709960-1 .. CS-709960-N
 *
 * @author kukabara
 */
public class ConductorTicket {
    int ticket;
    Date doneAt;
    ConductorBranch branch;
    List<ConductorPackage> packages;
    /* unused
    String name;
    String project;
    String author;
    String workflow;
    String deployGroup;
    */

    public List<ConductorPackage> getPackages() {
        return packages;
    }

    public ConductorBranch getBranch() {
        return branch;
    }

    public Date getDoneAt() {
        return doneAt;
    }

    public int getTicket() {
        return ticket;
    }

    public void setDoneAt(Date doneAt) {
        this.doneAt = doneAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConductorTicket)) {
            return false;
        }

        ConductorTicket conductorTicket = (ConductorTicket) o;

        if (ticket != conductorTicket.ticket) {
            return false;
        }
        if (branch != conductorTicket.branch) {
            return false;
        }
        return packages.equals(conductorTicket.packages);
    }

    @Override
    public int hashCode() {
        int result = ticket;
        result = 31 * result + branch.hashCode();
        result = 31 * result + packages.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ConductorTicket{" +
            "ticket=" + ticket +
            ", doneAt=" + doneAt +
            ", branch=" + branch +
            ", packages=" + packages +
            '}';
    }
}
