package ru.yandex.market.health;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.common.util.date.DateUtil;

import java.util.Date;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 16/11/15
 */
public class KeyValueLog {

    public static final DateUtil.ThreadLocalDateFormat ISO_8601_DATE_FORMAT = new DateUtil.ThreadLocalDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    private static final Logger keyValueLog = LogManager.getLogger("keyValue");

    public static void log(String key, double value) {
        log(new Date(), key, value);
    }

    public static void log(String key, String subkey, double value) {
        log(new Date(), key, subkey, value);
    }

    public static String format(Date date, String key, String subkey, double value) {
        return ISO_8601_DATE_FORMAT.format(date) + "\t" + key + "\t" + subkey + "\t" + value;
    }

    public static String format(Date date, String key, double value) {
        return ISO_8601_DATE_FORMAT.format(date) + "\t" + key + "\t" + value;
    }

    public static void log(Date date, String key, String subkey, double value) {
        keyValueLog.info(format(date, key, subkey, value));
    }

    public static void log(Date date, String key, double value) {
        keyValueLog.info(format(date, key, value));
    }
}
