package ru.yandex.market.juggler;

import com.google.gson.JsonObject;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 03/08/16
 */
public class JugglerEvent {
    private final String host;
    private final String service;
    private final Status status;
    private final String description;
    private final String instance;

    public JugglerEvent(String host, String service, Status status, String description) {
        this(host, service, status, description, "");
    }

    public JugglerEvent(String host, String service, Status status, String description, String instance) {
        this.host = host;
        this.service = service;
        this.status = status;
        this.description = description;
        this.instance = instance;
    }

    public String getHost() {
        return host;
    }

    public String getService() {
        return service;
    }

    public Status getStatus() {
        return status;
    }

    public String getDescription() {
        return description;
    }

    public String getInstance() {
        return instance;
    }

    public JsonObject toJsonObject() {
        JsonObject event = new JsonObject();
        event.addProperty("host", host);
        event.addProperty("service", service);
        event.addProperty("status", status.name());
        event.addProperty("host", host);
        event.addProperty("description", description);
        event.addProperty("instance", instance);
        return event;
    }

    public enum Status {
        OK,
        INFO,
        WARN,
        CRIT
    }

}
