package ru.yandex.market.log4j2;

import org.springframework.context.support.AbstractApplicationContext;
import ru.yandex.common.util.application.ApplicationBean;

import java.util.Collection;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 11/06/15
 */
public class ApplicationMain extends Main {
    public ApplicationMain(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        new ApplicationMain(args);
    }

    @Override
    protected AbstractApplicationContext startContainer() {
        try {
            final AbstractApplicationContext aac = super.startContainer();
            @SuppressWarnings({"unchecked"})
            final Collection<ApplicationBean> appbs = aac.getBeansOfType(
                ApplicationBean.class
            ).values();
            for (ApplicationBean appb : appbs) {
                appb.applicate();
            }
            return aac;
        } catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
            return null;
        }
    }
}
