package ru.yandex.market.log4j2;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescription;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescriptionImpl;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.status.StatusLogger;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 03/05/15
 */
@Plugin(name = "DummyRolloverStrategy", category = "Core")
public class DummyRolloverStrategy implements RolloverStrategy {

    private static Logger log = StatusLogger.getLogger();

    @Override
    public RolloverDescription rollover(RollingFileManager manager) throws SecurityException {
        log.info("Rotating: " + manager.getFileName());
        return new RolloverDescriptionImpl(manager.getFileName(), false, null, null);
    }
}
