package ru.yandex.market.log4j2;

import org.apache.logging.log4j.core.*;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.*;

import java.io.Serializable;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 03/05/15
 */
@Plugin(name = "LogRotateFile", category = "Core", elementType = "appender")
public class LogRotateFileAppender implements Appender {

    /**
     * Create a LogRotateFileAppender.
     *
     * @param fileName       The name of the file that is actively written to. (required).
     * @param append         If true, events are appended to the file. If false, the file
     *                       is overwritten when opened. Defaults to "true"
     * @param name           The name of the Appender (required).
     * @param bufferedIO     When true, I/O will be buffered. Defaults to "true".
     * @param bufferSizeStr  buffer size for buffered IO (default is 8192).
     * @param immediateFlush When true, events are immediately flushed. Defaults to "true".
     * @param layout         The layout to use (defaults to the default PatternLayout).
     * @param filter         The Filter or null.
     * @param ignore         If {@code "true"} (default) exceptions encountered when appending events are logged; otherwise
     *                       they are propagated to the caller.
     * @param advertise      "true" if the appender configuration should be advertised, "false" otherwise.
     * @param advertiseURI   The advertised URI which can be used to retrieve the file contents.
     * @param config         The Configuration.
     * @return A LogRotateFileAppender.
     */
    @PluginFactory
    public static RollingFileAppender createAppender(
        @PluginAttribute("fileName") final String fileName,
        @PluginAttribute("append") final String append,
        @PluginAttribute("name") final String name,
        @PluginAttribute("bufferedIO") final String bufferedIO,
        @PluginAttribute("bufferSize") final String bufferSizeStr,
        @PluginAttribute("immediateFlush") final String immediateFlush,
        @PluginElement("Layout") Layout<? extends Serializable> layout,
        @PluginElement("Filter") final Filter filter,
        @PluginAttribute("ignoreExceptions") final String ignore,
        @PluginAttribute("advertise") final String advertise,
        @PluginAttribute("advertiseURI") final String advertiseURI,
        @PluginConfiguration final Configuration config) {

        return RollingFileAppender.createAppender(
            fileName,
            "",
            append,
            name,
            bufferedIO,
            bufferSizeStr,
            immediateFlush,
            new SigHupTriggeringPolicy(),
            new DummyRolloverStrategy(),
            layout,
            filter,
            ignore,
            advertise,
            advertiseURI,
            config
        );
    }

    /**
     * Нужно обязательно наследовать Appender, так что пачка пустых методов
     * и приватный конструктор, что бы случайно не создали
     */
    private LogRotateFileAppender() {
    }

    @Override
    public void append(LogEvent event) {

    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Layout<? extends Serializable> getLayout() {
        return null;
    }

    @Override
    public boolean ignoreExceptions() {
        return false;
    }

    @Override
    public ErrorHandler getHandler() {
        return null;
    }

    @Override
    public void setHandler(ErrorHandler handler) {

    }

    @Override
    public State getState() {
        return null;
    }

    @Override
    public void start() {

    }

    @Override
    public void stop() {

    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public boolean isStopped() {
        return false;
    }
}
