package ru.yandex.market.log4j2;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.io.IoBuilder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import ru.yandex.common.util.application.SettingsLoader;
import ru.yandex.common.util.application.SimpleSettingsLoader;

import java.util.ArrayList;

import static ru.yandex.common.util.collections.CollectionFactory.list;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 05/05/15
 */
public class Main {


    private final String[] args;
    protected final SettingsLoader settingsLoader;

    public static void main(String[] args) {
        new Main(args);
    }

    //
    protected final ApplicationContext ctx;


    public Main(final String[] args) {
        this.args = args;
        this.settingsLoader = getSettingsLoader();

        redirectStdLogs();
        this.ctx = startContainer();
    }

    private void redirectStdLogs() {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        System.setOut(IoBuilder.forLogger("SystemOut").setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger("SystemErr").setLevel(Level.ERROR).buildPrintStream());
    }

    protected SettingsLoader getSettingsLoader() {
        return SimpleSettingsLoader.getInstance();
    }

    protected AbstractApplicationContext startContainer() {
        final String filename =
            settingsLoader.getSystemProperties().getProperty(
                "bean.file",
                settingsLoader.getSettings()
                    .getProperty("bean.file", "bean.xml")
            );

        final ApplicationContext parent = getEnvironmentApplicationContext();
        return new FileSystemXmlApplicationContext(
            new String[]{filename}, parent);
    }

    // creates application context of one bean named 'mainArgs' that is a list of program arguments
    private ApplicationContext getEnvironmentApplicationContext() {
        final StaticApplicationContext sac = new StaticApplicationContext(null);
        final ConstructorArgumentValues cav = new ConstructorArgumentValues();
        cav.addGenericArgumentValue(list(args));
        sac.registerBeanDefinition(
            "mainArgs",
            new RootBeanDefinition(
                ArrayList.class,
                new ConstructorArgumentValues(cav),
                null));
        sac.refresh();
        return sac;
    }

}
