package ru.yandex.market.log4j2;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.status.StatusLogger;
import sun.misc.Signal;
import sun.misc.SignalHandler;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 03/05/15
 * @deprecated use log rotation via log4j2
 */
@Deprecated
@Plugin(name = "SigHupTriggeringPolicy", category = "Core")
public class SigHupTriggeringPolicy implements TriggeringPolicy {
    private static Logger log = StatusLogger.getLogger();

    private static final String SIGNAL_NAME = "HUP";
    private static volatile long lastSigTime = 0;
    private volatile long lastTriggerTime = 0;

    static {
        Signal.handle(new Signal(SIGNAL_NAME), new SignalHandler() {
            @Override
            public void handle(Signal signal) {
                log.info("Caught SIGHUP. Rotating files.");
                lastSigTime = System.currentTimeMillis();
            }
        });
    }

    @Override
    public void initialize(RollingFileManager manager) {
    }

    @Override
    public boolean isTriggeringEvent(LogEvent event) {
        if (lastTriggerTime < lastSigTime) {
            lastTriggerTime = lastSigTime;
            return true;
        } else {
            return false;
        }
    }
}
