package ru.yandex.market.monitoring;

import com.google.common.collect.EvictingQueue;

import java.util.ArrayList;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author artemmz
 *         created on 26.09.16.
 */
public class AppendableMonitoringUnit extends MonitoringUnit {
    private static final int MAX_EVENTS_TO_STORE = 100;
    private final Queue<String> eventQueue;

    public AppendableMonitoringUnit(String name) {
        this(name, MAX_EVENTS_TO_STORE);
    }

    public AppendableMonitoringUnit(String name, int delay, TimeUnit timeUnit) {
        this(name, delay, timeUnit, MAX_EVENTS_TO_STORE);
    }

    public AppendableMonitoringUnit(String name, int maxEventsToStore) {
        super(name);
        eventQueue = EvictingQueue.create(maxEventsToStore);
    }

    public AppendableMonitoringUnit(String name, int delay, TimeUnit timeUnit, int maxEventsToStore) {
        super(name, delay, timeUnit);
        eventQueue = EvictingQueue.create(maxEventsToStore);
    }

    @Override
    protected synchronized void update(MonitoringStatus status, String message, Throwable exception) {
        this.status = status;
        this.exception = exception;
        if (message != null && status != MonitoringStatus.OK) {
            problemStartTimeMillis = System.currentTimeMillis();
            eventQueue.add(String.format("[%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS] ", new Date(problemStartTimeMillis)) + message);
        }
    }

    @Override
    public String getMessage() {
        return new ArrayList<>(eventQueue).stream().collect(Collectors.joining("\n"));
    }
}
