package ru.yandex.market.monitoring;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 20/04/15
 * @deprecated instead use {@link ru.yandex.market.application.monitoring.ComplicatedMonitoring}
 */
@Deprecated
public class ComplicatedMonitoring {
    private final ConcurrentHashMap<String, UnitWrapper> units = new ConcurrentHashMap<>();

    private static final Result OK_RESULT = new Result(MonitoringStatus.OK, MonitoringStatus.OK.getGolemName());

    private volatile Result result;

    private MonitoringMetaDao monitoringMetaDao;

    public MonitoringUnit getOrAddUnit(String unitName) {
        UnitWrapper unitWrapper = new UnitWrapper(new MonitoringUnit(unitName));
        UnitWrapper result = units.putIfAbsent(unitName, unitWrapper);
        return (result == null) ? unitWrapper.unit : result.unit;
    }

    public MonitoringUnit createUnit(String name) {
        MonitoringUnit unit = new MonitoringUnit(name);
        addUnit(unit);
        return unit;
    }

    public MonitoringUnit createUnit(String name, int delay, TimeUnit timeUnit) {
        MonitoringUnit unit = new MonitoringUnit(name, delay, timeUnit);
        addUnit(unit);
        return unit;
    }

    public void addUnit(MonitoringUnit unit) {
        units.put(unit.getName(), new UnitWrapper(unit));
    }

    public PersistedMonitoringUnit createPersistUnit(String name) {
        final PersistedMonitoringUnit persistedMonitoringUnit = new PersistedMonitoringUnit(name, monitoringMetaDao);
        addUnit(persistedMonitoringUnit);
        return persistedMonitoringUnit;
    }

    public void addTemporaryCritical(String name, String message, long time, TimeUnit timeUnit) {
        addTemporary(name, MonitoringStatus.CRITICAL, message, time, timeUnit);
    }

    public void addTemporaryWarning(String name, String message, long time, TimeUnit timeUnit) {
        addTemporary(name, MonitoringStatus.WARNING, message, time, timeUnit);
    }

    private void addTemporary(String name, MonitoringStatus status, String message, long time, TimeUnit timeUnit) {
        MonitoringUnit unit = new MonitoringUnit(name);
        switch (status) {
            case WARNING:
                unit.warning(message);
                break;
            case CRITICAL:
                unit.critical(message);
                break;
        }
        long validTillMillis = System.currentTimeMillis() + timeUnit.toMillis(time);
        addTemporaryUntil(unit, validTillMillis);
    }

    public void addTemporary(MonitoringUnit unit, long time, TimeUnit timeUnit) {
        long validTillMillis = System.currentTimeMillis() + timeUnit.toMillis(time);
        addTemporaryUntil(unit, validTillMillis);
    }

    public void addTemporaryUntil(MonitoringUnit unit, long validTillMillis) {
        if (unit.getStatus().equals(MonitoringStatus.OK)) {
            removeUnit(unit.getName());
        } else {
            units.put(unit.getName(), new UnitWrapper(unit, validTillMillis));
        }
    }

    public void addTemporaryUntil(MonitoringUnit unit, Date date) {
        addTemporaryUntil(unit, date.getTime());
    }

    public Result getResult() {
        updateResult();
        return result;
    }

    public Result getResult(String monitoringName) {
        UnitWrapper unitWrapper = units.get(monitoringName);
        if (unitWrapper != null) {
            if (!unitWrapper.isValid()) {
                units.remove(monitoringName);
                return OK_RESULT;
            } else {
                MonitoringUnit unit = unitWrapper.unit;
                synchronized (unit) {
                    switch (unit.getStatus()) {
                        case OK:
                            return OK_RESULT;
                        case WARNING:
                        case CRITICAL:
                            return new Result(unit.getStatus(), unit.getName() + ": " + unit.getMessage());
                        default:
                            throw new IllegalArgumentException("Unknown monitoring unit status");
                    }
                }
            }
        } else {
            return new Result(MonitoringStatus.WARNING, "Unknown monitoring name: " + monitoringName);
        }
    }

    private void updateResult() {
        final MonitoringResultBuilder monitoringResultBuilder = new MonitoringResultBuilder();
        Iterator<Map.Entry<String, UnitWrapper>> unitIterator = units.entrySet().iterator();
        while (unitIterator.hasNext()) {
            Map.Entry<String, UnitWrapper> unitEntry = unitIterator.next();
            if (!unitEntry.getValue().isValid()) {
                unitIterator.remove();
                continue;
            }
            MonitoringUnit unit = unitEntry.getValue().unit;
            synchronized (unit) {
                monitoringResultBuilder.addUnit(unit);
            }
        }

        result = monitoringResultBuilder.getResult();
    }

    private void removeUnit(String name) {
        units.remove(name);
    }

    public static Result combine(ComplicatedMonitoring... monitorings) {
        ComplicatedMonitoring combinedMonitoring = new ComplicatedMonitoring();
        for (ComplicatedMonitoring monitoring : monitorings) {
            combinedMonitoring.units.putAll(monitoring.units);
        }
        return combinedMonitoring.getResult();
    }

    public static class Result {
        private final MonitoringStatus status;
        private final String message;

        public Result(MonitoringStatus status, String message) {
            this.status = status;
            this.message = message;
        }

        public MonitoringStatus getStatus() {
            return status;
        }

        public String getMessage() {
            return message;
        }

        @Override
        public String toString() {
            return status.getCode() + ";" + message;
        }
    }

    static class MonitoringResultBuilder {
        final Map<MonitoringStatus, StringBuilder> events = new HashMap<>();

        void addUnit(MonitoringUnit unit) {
            if (unit.getMessage() != null || unit.getStatus() != MonitoringStatus.OK) {
                StringBuilder statusBuilder = events.get(unit.getStatus());

                if (statusBuilder == null) {
                    statusBuilder = new StringBuilder();
                    events.put(unit.getStatus(), statusBuilder);
                } else {
                    statusBuilder.append(", ");
                }

                statusBuilder.append(unit.getName()).append(": ").append(unit.getMessage());
            }
        }

        Result getResult() {
            final StringBuilder messageBuilder = new StringBuilder();
            MonitoringStatus resultStatus = null;

            for (MonitoringStatus status : MonitoringStatus.valuesInPriorityOrder()) {
                final StringBuilder statusEvents = events.get(status);
                if (statusEvents != null) {
                    if (messageBuilder.length() != 0) {
                        messageBuilder.append(" ");
                    }
                    messageBuilder.append(status.getGolemName()).append(" {").append(statusEvents).append("}");
                    if (resultStatus == null) {
                        resultStatus = status;
                    }
                }
            }

            if (messageBuilder.length() == 0) {
                return OK_RESULT;
            } else {
                return new Result(resultStatus, messageBuilder.toString());
            }
        }
    }

    private static class UnitWrapper {
        private final MonitoringUnit unit;
        private final long validTillMillis;

        public UnitWrapper(MonitoringUnit unit, long validTillMillis) {
            this.unit = unit;
            this.validTillMillis = validTillMillis;
        }

        public UnitWrapper(MonitoringUnit unit) {
            this(unit, -1);
        }

        private boolean isValid() {
            if (validTillMillis < 0) {
                return true;
            }
            return System.currentTimeMillis() <= validTillMillis;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            UnitWrapper that = (UnitWrapper) o;
            return Objects.equals(unit, that.unit);
        }

        @Override
        public int hashCode() {
            return Objects.hash(unit);
        }
    }

    public void setMonitoringMetaDao(MonitoringMetaDao monitoringMetaDao) {
        this.monitoringMetaDao = monitoringMetaDao;
    }
}
