package ru.yandex.market.monitoring;

import java.util.Arrays;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 20/04/15
 */
public enum MonitoringStatus implements Comparable<MonitoringStatus> {
    OK(0, "OK"),
    WARNING(1, "WARN"),
    CRITICAL(2, "CRIT");

    private final int code;
    private final String golemName;
    private static MonitoringStatus[] valuesInPriorityOrder = new MonitoringStatus[]{
        CRITICAL,
        WARNING,
        OK
    };

    MonitoringStatus(int code, String golemName) {
        this.code = code;
        this.golemName = golemName;
    }

    public int getCode() {
        return code;
    }

    public String getGolemName() {
        return golemName;
    }

    public static MonitoringStatus[] valuesInPriorityOrder() {
        return Arrays.copyOf(valuesInPriorityOrder, valuesInPriorityOrder.length);
    }
}
